import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class ImageResizeSection extends StatefulWidget {
  const ImageResizeSection({Key? key}) : super(key: key);

  @override
  _ImageResizeSectionState createState() => _ImageResizeSectionState();
}

class _ImageResizeSectionState extends State<ImageResizeSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Image Resize Options',
      description: 'Upload process stores both the original and a compressed version of same image.'
          'Compressed version of image is used on places where load times are critical.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_RES,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_RES,
          type: FieldType.text,
          leading: 'Compressed Resolution - User Images',
          placeholder: 'e.g 150',
          description: "If you set this value to 150, images will be resized to x-150 and y-(aspect ratio).",
        ),
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_RES,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_RES,
          type: FieldType.text,
          leading: 'Compressed Resolution - Post Images',
          placeholder: 'e.g 500',
          description: "If you set this value to 500, images will be resized to x-500 and y-(aspect ratio).",
        ),
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_RES,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_RES,
          type: FieldType.text,
          leading: 'Compressed Resolution - Collection Cover',
          placeholder: 'e.g 200',
          description: "If you set this value to 200, images will be resized to x-200 and y-(aspect ratio).",
        ),
      ],
    );
  }
}
